/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#include <linux/wait.h>
#include <scc/scc_types.h>
#include <scc/mtcl.h>


#define MTCL_VERSION_MAJOR 1
#define MTCL_VERSION_MINOR 0
#define MTCL_VERSION_REVISION 0

#define MTCL_DEV_MAJOR 154
#define MTCL_DEV_MINOR_NUM 1

#define MTCL_IOC_MAGIC   'M'

typedef struct _mtcl_void_arg_t {
    INT32 error;
} mtcl_void_arg_t;

typedef struct _mtcl_streamtype_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT8 stream;
} mtcl_streamtype_arg_t;

typedef struct _mtcl_dmarate_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT8 rate;
    UINT8 ats;
} mtcl_dmarate_arg_t;

typedef struct _mtcl_start_dma_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT32 size;
    UINT32 offset;
    UINT8 mode;
    UINT8 syncptr;
} mtcl_start_dma_arg_t;

typedef struct _mtcl_dmach_arg_t {
    INT32 error;
    UINT32 dma_ch;
} mtcl_dmach_arg_t;

typedef struct _mtcl_assign_buf_dma_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT32 buf_id;
    UINT8 loop;
} mtcl_assign_buf_dma_arg_t;

typedef struct _mtcl_dmainfo_arg_t {
    INT32 error;
    UINT32 dma_ch;
    MTCL_dmainfo_t dma_info;
} mtcl_dmainfo_arg_t;

typedef struct _mtcl_dmaptr_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT8 mode;
    UINT32 offset;
} mtcl_dmaptr_arg_t;

typedef struct _mtcl_eventmask_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT32 mask;
} mtcl_eventmask_arg_t;

typedef struct _mtcl_dmatime_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT32 start_time;
    UINT32 end_time;
} mtcl_dmatime_arg_t;

typedef struct _mtcl_hw_dmainfo_arg_t {
    INT32 error;
    UINT32 dma_ch;
    UINT32 hw_info;
} mtcl_hw_dmainfo_arg_t;

typedef struct _mtcl_send_event_arg_t{
    INT32 error;
    UINT32 dma_ch;
    UINT32 event;
}mtcl_send_event_arg_t;

typedef union _mtcl_arg_t{
    INT32 error;
    mtcl_void_arg_t void_arg;
    mtcl_streamtype_arg_t streamtype;
    mtcl_dmarate_arg_t dmarate;
    mtcl_start_dma_arg_t start_dma;
    mtcl_dmach_arg_t dmach;
    mtcl_assign_buf_dma_arg_t assign_buf_dma;
    mtcl_dmainfo_arg_t dmainfo;
    mtcl_dmaptr_arg_t dmaptr;
    mtcl_eventmask_arg_t eventmask;
    mtcl_dmatime_arg_t dmatime;
    mtcl_hw_dmainfo_arg_t hw_dmainfo;
    mtcl_send_event_arg_t send_event;
}mtcl_arg_t;

typedef struct _mtcl_irq_notify_arg_t{
    UINT32 dma_ch;
    UINT32 result;
}mtcl_irq_notify_arg_t;

#define MTCL_IOC_ASSIGN_BUF_DMA _IOR(MTCL_IOC_MAGIC, 2, mtcl_assign_buf_dma_arg_t)
#define MTCL_IOC_RELEASE_BUF_DMA _IOR(MTCL_IOC_MAGIC, 3, mtcl_dmach_arg_t)
#define MTCL_IOC_SET_DMAPTR _IOR(MTCL_IOC_MAGIC, 4, mtcl_dmaptr_arg_t)
#define MTCL_IOC_SET_STREAMTYPE _IOR(MTCL_IOC_MAGIC, 5, mtcl_streamtype_arg_t)
#define MTCL_IOC_SET_DMARATE _IOR(MTCL_IOC_MAGIC, 6, mtcl_dmarate_arg_t)
#define MTCL_IOC_START_DMA _IOR(MTCL_IOC_MAGIC, 7, mtcl_start_dma_arg_t)
#define MTCL_IOC_STOP_DMA _IOR(MTCL_IOC_MAGIC, 8, mtcl_dmach_arg_t)
#define MTCL_IOC_GET_DMAINFO _IOR(MTCL_IOC_MAGIC, 10, mtcl_dmainfo_arg_t)
#define MTCL_IOC_REGISTER_DMANOTIFY _IOR(MTCL_IOC_MAGIC, 11, mtcl_dmach_arg_t)
#define MTCL_IOC_UNREGISTER_DMANOTIFY _IOR(MTCL_IOC_MAGIC, 12, mtcl_dmach_arg_t)
#define MTCL_IOC_SET_EVENTMASK _IOR(MTCL_IOC_MAGIC, 13, mtcl_eventmask_arg_t)
#define MTCL_IOC_SEND_EVENT _IOR(MTCL_IOC_MAGIC, 16, mtcl_send_event_arg_t)
